TITLE   'Temperature Step in Bar'					{ exa182x.pde }
SELECT     errlim=1e-3
COORDINATES
   cartesian1
VARIABLES    temp
DEFINITIONS
   Lx=1.0     heat=0     k=82     rcp=7.87e3*449 		{ Iron }
   fluxd_x=-k*dx(temp)
INITIAL VALUES
   temp=200+200*ustep( x-Lx/2)           	{ Unit step function }
EQUATIONS
   dx( fluxd_x)+ rcp*dt( temp)=heat
BOUNDARIES
region 'domain'
   start (0)  line to (Lx)  		{ Temperature for t> 0 }
TIME   from 0 to 100000
PLOTS
   for t=10, 30, 100, 300, 1000, 3000, 10000, 30000, 100000
   elevation( temp) from (0) to (Lx)
END






